/*------------------------------------------------------------------

    System requests interface file z3dDummyLightRender.h v1.0

  Requirements: ZModeler v1.06 or higher.
  Include this file, if you want to use supplied system requests.

    Author:     Oleg M.
    History:    05.May.2002 - First implementation

  This file provides the following requests for dummy lights:
  - Creation
  - Deleting
  - Assignment
  - Removing
  - Getting info
  - Setting info
  - Displaying dialog box


--------------------------------------------------------------------*/
#ifndef Z3D_DUMMY_LIGHT_RENDER_INCLUDED
#define Z3D_DUMMY_LIGHT_RENDER_INCLUDED


// Maximum amount of phases in animation
#define Z3D_DUMMY_LIGHT_MAX_PHASES        20

// Unique ID for Dummy-light rendering method
#define Z3D_DUMMY_LIGHT_RENDERING_ID      0x30

// Unique z3d file chunk ID for Dummy-light rendering method
#define Z3D_DUMMY_LIGHT_RENDERING_CHINKID 0x00001030


//      Controlling struct. It contains full info about
// one dummy-light. Several objects can share one dummy.
//      To assign a dummy light to an object, use
// Z3D_DUMMY_LIGHT_ASSIGN system request with a desired
// ID and Object.
typedef struct tDummyLight
{
  //personal light's ID. Objects are reffering this ID;
  DWORD   dwDummyLightID;

  //currently unused. It will use ZLights.zmp plugin later.
  DWORD   dwAssociatedLightID;

  //Amount of phases in animation.
  //It can range from 2 to Z3D_DUMMY_LIGHT_MAX_PHASES
  DWORD   dwNumPhases;
  //name of dummy-light. Used in dialog-box only.
  char    name[MAX_OBJECT_NAMELENGTH];
  //number of texture sample. Currenly can be in range [0..3]
  DWORD   dwTextureSample;
  // generic size of the light in ZModeler's untis. Default is 0.3f;
  float   fGenericSize;
  // Bitwise-or combination of flags (see below)
  DWORD   dwFlags;
  // Duration of animation (from first phase till last). It
  // assumes 30fps animation, so by settin it to 60, you set up
  // two-seconds animation.
  DWORD   dwDuration;

  // controllers:
  struct tagPhases
  {
    // start of the phase in range [0..dwDuration]
    DWORD   dwPhaseStart;
    // color in order 0xBBGGRR
    DWORD   dwColor;
    // opacity in range [0.0f..1.0f]
    float   fOpacity;
    // rotation in range [0.0f..1.0f] = [-M_PI/2..M_PI/2]
    float   fRotation;
    // width (x local-axis) stratch in range [0..1]
    // where 0 == 1%, 0.5 == 100%, 1.0 == 1000%
    float   fXStratch;
    // height (y local-axis) stratch in range [0..1]
    // where 0 == 1%, 0.5 == 100%, 1.0 == 1000%
    float   fYStratch;
    // FOV for visibility in range [0..1] = [0..M_PI]
    float   fFOVRange;    
    // amount of frames per full Y-axis turn,
    // 0: no Y-Rotation;
    //non-zero: animation frames per 360 degreese Y turn
    DWORD   dwYFullTurn;  
                          
  }Phases[Z3D_DUMMY_LIGHT_MAX_PHASES];

//------------------------------
// internal use only:

  // Current animation frame:
  DWORD   dwFrame;

  // simple linked list
  tDummyLight*  pNext;

  // function for writing into Z3D file
  long Write(CFile* pFile);
  // function for reading from Z3D file
  long Read(CFile* pFile);
}tDummyLight, *lptDummyLight, **lpptDummyLight;


//-------------------------------------------------------------
// bit flags for dwFlags data member:
#define Z3D_DUMMY_LIGHT_RENDER_ZENABLE          0x0001
#define Z3D_DUMMY_LIGHT_RENDER_ZWRITEENABLE     0x0002
#define Z3D_DUMMY_LIGHT_RENDER_NO_ANIMATION     0x0010
#define Z3D_DUMMY_LIGHT_RENDER_STATIC_DIRECTION 0x0020
#define Z3D_DUMMY_LIGHT_RENDER_HAS_LIGHT_SOURCE 0x0100


//-------------------------------------------------------------
// System requests part:
//-------------------------------------------------------------
//    SYSTEMREQUESTPROC is the following proc:
// typedef DWORD  (FAR CALLBACK *SYSTEMREQUESTPROC)(
//      sRequestType RT,
//      tObjectSet* pObjs,
//      char* pDefaultString,
//      void* param1,
//      void* param2);
//-------------------------------------------------------------


// Creation of dummy-light
// Parameters:
// pObjs          - ignored
// pDefaultString - Name of new dl
// param1         - lptDummyLight with settings, or NULL to force creation
// param2         - ignored
//
// returns ID of created dummy
#define Z3D_USERREQUEST_CREATE_DUMMY_LIGHT    0x00008010


// Deleting of dummy-light
// Parameters:
// pObjs          - ignored
// pDefaultString - ignored
// param1         - pointer to DWORD with ID of desired dl
// param2         - ignored
//
// returns 1 on success and 0 on fail
#define Z3D_USERREQUEST_DELETE_DUMMY_LIGHT    0x00008011


// Assignment of dummy-light
// Parameters:
// pObjs          - ignored
// pDefaultString - ignored
// param1         - pointer to DWORD with ID of desired dl
// param2         - pointer to tObject that will accept assignment
//
// returns 1 on success and 0 on fail
#define Z3D_USERREQUEST_ASSIGN_DUMMY_LIGHT    0x00008012


// Removing of assignment
// Parameters:
// pObjs          - ignored
// pDefaultString - ignored
// param1         - pointer to tObject that was previousely assigned
// param2         - ignored
//
// returns 1 on success and 0 on fail
#define Z3D_USERREQUEST_REMOVE_DUMMY_LIGHT    0x00008013


// Setting of dl info
// Parameters:
// pObjs          - ignored
// pDefaultString - ignored
// param1         - pointer to DWORD with ID of desired dl
// param2         - lptDummyLight with new settings
//
// returns 1 on success and 0 on fail
#define Z3D_USERREQUEST_SETINFO_DUMMY_LIGHT   0x00008014


// Getting of dl info
// Parameters:
// pObjs          - ignored
// pDefaultString - ignored
// param1         - pointer to DWORD with ID of desired dl
// param2         - address of lptDummyLight variable where an address
//                  of tDummyLight struct will be placed. Don't delete
//                  supplied pointer afterward.
//
// returns 1 on success and 0 on fail
#define Z3D_USERREQUEST_GETINFO_DUMMY_LIGHT   0x00008015


// Displays settings dialog box
// Parameters:
// pObjs          - Contains objects set where desired objects are SELected
// pDefaultString - ignored
// param1         - ignored
// param2         - ignored
//
// returns IDOK or IDCANCEL
#define Z3D_USERREQUEST_SHOWBOX_DUMMY_LIGHT   0x00008016

#endif /* Z3D_DUMMY_LIGHT_RENDER_INCLUDED */